#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{

	
	

	[TestFixture]
	public class DAL_ABORh : BaseTest 
	{
		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();
		}

		[Test]
		public void GetAllABORh_Pass()
		{
			DataTable dt = DAL.AboRh.GetAllAboRH();

			Assert.AreEqual(true, dt.Rows.Count > 0, "Rows.Count");

			//Verify the columns are there  -- should it just be a count and no name verification?
			Assert.AreEqual(3, dt.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dt.Columns.Contains(ARTIFICIAL.BloodTypeRhFactor), ARTIFICIAL.BloodTypeRhFactor);
			Assert.AreEqual(true, dt.Columns.Contains(TABLES.ScanBloodType.BloodTypeCode), TABLES.ScanBloodType.BloodTypeCode);
			Assert.AreEqual(true, dt.Columns.Contains(TABLES.RhFactor.RhFactorCode), TABLES.RhFactor.RhFactorCode);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetAllABORh_Fail()
		{
		}


	}
}
#endif
